/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.J3dClock;
import javax.media.j3d.J3dI18N;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

abstract class GeometryDecompressor {
    private static final boolean debug = false;
    private static final boolean benchmark = false;
    static final int majorVersionNumber = 1;
    static final int minorVersionNumber = 0;
    static final int minorMinorVersionNumber = 2;
    private static final int GC_VERTEX = 64;
    private static final int GC_SET_NORM = 192;
    private static final int GC_SET_COLOR = 128;
    private static final int GC_MESH_B_R = 32;
    private static final int GC_SET_STATE = 24;
    private static final int GC_SET_TABLE = 16;
    private static final int GC_PASS_THROUGH = 8;
    private static final int GC_EOS = 0;
    private static final int GC_V_NO_OP = 1;
    private static final int GC_SKIP_8 = 7;
    private HuffmanTableEntry[][] gctables;
    private MeshBufferEntry[] meshBuffer;
    private int meshIndex = 15;
    private int meshState;
    private static final int USE_MESH_NORMAL = 1;
    private static final int USE_MESH_COLOR = 2;
    private short curX;
    private short curY;
    private short curZ;
    private short curR;
    private short curG;
    private short curB;
    private short curA;
    private int curSex;
    private int curOct;
    private int curU;
    private int curV;
    private Point3f curPos = new Point3f();
    private Vector3f curNorm = new Vector3f();
    private Color4f curColor = new Color4f();
    private int repCode;
    private boolean bundlingNorm;
    private boolean bundlingColor;
    private boolean doingAlpha;
    private int currentHeader = 0;
    private int nextHeader = 0;
    private int bitBuffer = 0;
    private int bitBufferCount = 32;
    private long startTime;
    private int vertexCount;
    private static final int[] BMASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private byte[] gcData;
    private int gcIndex;
    private static final double[][][] gcNormals = new double[65][65][3];
    private static final double NORMAL_MAX_Y_ANG = 0.615479709;
    private static final boolean printNormalTable = false;

    abstract void outputVertexFormat(boolean var1, boolean var2, boolean var3);

    abstract void outputVertex(Point3f var1, Vector3f var2, Color4f var3, int var4);

    abstract void outputColor(Color4f var1);

    abstract void outputNormal(Vector3f var1);

    GeometryDecompressor() {
        int n2;
        this.gctables = new HuffmanTableEntry[3][64];
        for (n2 = 0; n2 < 64; ++n2) {
            this.gctables[0][n2] = new HuffmanTableEntry();
            this.gctables[1][n2] = new HuffmanTableEntry();
            this.gctables[2][n2] = new HuffmanTableEntry();
        }
        this.meshBuffer = new MeshBufferEntry[16];
        for (n2 = 0; n2 < 16; ++n2) {
            this.meshBuffer[n2] = new MeshBufferEntry();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean checkVersion(int n2, int n3) {
        if (n2 < 1) return true;
        if (n2 != 1) return false;
        if (n3 > 0) return false;
        return true;
    }

    void decompress(int n2, int n3, byte[] byArray) {
        if (n2 + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryDecompressor0"));
        }
        this.gcData = byArray;
        this.gcIndex = n2;
        this.bitBufferCount = 0;
        this.meshState = 0;
        this.bundlingNorm = false;
        this.bundlingColor = false;
        this.doingAlpha = false;
        this.repCode = 0;
        this.nextHeader = 1;
        while (this.gcIndex < n2 + n3) {
            this.processDecompression();
        }
        while (this.bitBufferCount > 0) {
            this.processDecompression();
        }
    }

    private int getBits(int n2, String string) {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        if (this.bitBufferCount == 0) {
            this.bitBuffer = (this.gcData[this.gcIndex++] & 0xFF) << 24 | (this.gcData[this.gcIndex++] & 0xFF) << 16 | (this.gcData[this.gcIndex++] & 0xFF) << 8 | this.gcData[this.gcIndex++] & 0xFF;
            this.bitBufferCount = 32;
        }
        if (this.bitBufferCount >= n2) {
            n3 = this.bitBuffer >>> 32 - n2 & BMASK[n2];
            this.bitBuffer <<= n2;
            this.bitBufferCount -= n2;
        } else {
            n3 = this.bitBuffer >>> 32 - n2 & BMASK[n2];
            n3 >>>= n2 - this.bitBufferCount;
            n3 <<= n2 - this.bitBufferCount;
            this.bitBuffer = (this.gcData[this.gcIndex++] & 0xFF) << 24 | (this.gcData[this.gcIndex++] & 0xFF) << 16 | (this.gcData[this.gcIndex++] & 0xFF) << 8 | this.gcData[this.gcIndex++] & 0xFF;
            n3 |= this.bitBuffer >>> 32 - (n2 - this.bitBufferCount) & BMASK[n2 - this.bitBufferCount];
            this.bitBuffer <<= n2 - this.bitBufferCount;
            this.bitBufferCount = 32 - (n2 - this.bitBufferCount);
        }
        return n3;
    }

    private void processDecompression() {
        this.currentHeader = this.nextHeader;
        if ((this.currentHeader & 0xC0) == 64) {
            if (!this.bundlingNorm && !this.bundlingColor) {
                this.nextHeader = this.getBits(8, "header");
                int n2 = this.processDecompressionOpcode(0);
            } else if (this.bundlingNorm && !this.bundlingColor) {
                this.nextHeader = this.getBits(6, "normal");
                int n3 = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0xC0;
                this.nextHeader = this.getBits(8, "header");
                this.processDecompressionOpcode(n3);
            } else if (!this.bundlingNorm && this.bundlingColor) {
                this.nextHeader = this.getBits(6, "color");
                int n4 = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0x80;
                this.nextHeader = this.getBits(8, "header");
                this.processDecompressionOpcode(n4);
            } else {
                this.nextHeader = this.getBits(6, "normal");
                int n5 = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0xC0;
                this.nextHeader = this.getBits(6, "color");
                this.processDecompressionOpcode(n5);
                this.currentHeader = this.nextHeader | 0x80;
                this.nextHeader = this.getBits(8, "header");
                this.processDecompressionOpcode(n5);
            }
            this.outputVertex(this.curPos, this.curNorm, this.curColor, this.repCode);
            this.meshState |= 1;
            this.meshState |= 2;
        } else {
            this.nextHeader = this.getBits(8, "header");
            this.processDecompressionOpcode(0);
        }
    }

    private int processDecompressionOpcode(int n2) {
        if ((this.currentHeader & 0xC0) == 192) {
            this.processSetNormal(n2);
        } else if ((this.currentHeader & 0xC0) == 128) {
            this.processSetColor(n2);
        } else {
            if ((this.currentHeader & 0xC0) == 64) {
                return this.processVertex();
            }
            if ((this.currentHeader & 0xE0) == 32) {
                this.processMeshBR();
                this.outputVertex(this.curPos, this.curNorm, this.curColor, this.repCode);
                this.meshState |= 1;
                this.meshState |= 2;
            } else if ((this.currentHeader & 0xF8) == 24) {
                this.processSetState();
            } else if ((this.currentHeader & 0xF8) == 16) {
                this.processSetTable();
            } else if ((this.currentHeader & 0xFF) == 0) {
                this.processEos();
            } else if ((this.currentHeader & 0xFF) == 1) {
                this.processVNoop();
            } else if ((this.currentHeader & 0xFF) == 8) {
                this.processPassThrough();
            } else if ((this.currentHeader & 0xFF) == 7) {
                this.processSkip8();
            }
        }
        return 0;
    }

    private void processSetState() {
        int n2 = this.getBits(3, "bundling");
        this.bundlingNorm = (this.currentHeader & 1) != 0;
        this.bundlingColor = (n2 >>> 2 & 1) != 0;
        this.doingAlpha = (n2 >>> 1 & 1) != 0;
        this.outputVertexFormat(this.bundlingNorm, this.bundlingColor, this.doingAlpha);
    }

    private void processSetTable() {
        int n2;
        int n3 = (this.currentHeader & 6) >>> 1;
        HuffmanTableEntry[] huffmanTableEntryArray = this.gctables[n3];
        int n4 = this.getBits(15, "set table");
        int n5 = (this.currentHeader & 1) << 6 | n4 >>> 9 & 0x3F;
        int n6 = n4 >>> 5 & 0xF;
        if (n6 == 0 && n3 != 2) {
            n6 = 16;
        }
        int n7 = n4 & 0xF;
        int n8 = n4 >>> 4 & 1;
        for (n2 = 6; n2 > 0 && n5 >> n2 == 0; --n2) {
        }
        n5 = n5 << 6 - n2 & 0x3F;
        for (int i2 = 0; i2 < 1 << 6 - n2; ++i2) {
            huffmanTableEntryArray[n5 + i2].tagLength = n2;
            huffmanTableEntryArray[n5 + i2].dataLength = n6;
            huffmanTableEntryArray[n5 + i2].rightShift = n7;
            huffmanTableEntryArray[n5 + i2].absolute = n8;
        }
    }

    private int processVertex() {
        int n2;
        int n3;
        int n4;
        this.meshState = 0;
        HuffmanTableEntry huffmanTableEntry = this.gctables[0][this.currentHeader & 0x3F];
        int n5 = huffmanTableEntry.dataLength - huffmanTableEntry.rightShift;
        if (6 - 3 * n5 - huffmanTableEntry.tagLength > 0) {
            int n6 = 6 - 3 * n5 - huffmanTableEntry.tagLength;
            int n7 = this.currentHeader & BMASK[n6];
            n4 = this.getBits(3 - n6, "repcode/mbp");
            n4 |= n7 << 3 - n6;
        } else {
            n4 = this.getBits(3, "repcode/mbp");
        }
        this.repCode = n4 >>> 1;
        int n8 = n4 & 1;
        int n9 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength];
        if (huffmanTableEntry.tagLength + n5 == 6) {
            n3 = this.getBits(n5, "y");
            n2 = this.getBits(n5, "z");
        } else if (huffmanTableEntry.tagLength + n5 < 6) {
            n9 >>= 6 - huffmanTableEntry.tagLength - n5;
            n3 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - n5];
            if (huffmanTableEntry.tagLength + 2 * n5 == 6) {
                n2 = this.getBits(n5, "z");
            } else if (huffmanTableEntry.tagLength + 2 * n5 < 6) {
                n3 >>= 6 - huffmanTableEntry.tagLength - 2 * n5;
                n2 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - 2 * n5];
                if (huffmanTableEntry.tagLength + 3 * n5 < 6) {
                    n2 >>= 6 - huffmanTableEntry.tagLength - 3 * n5;
                } else if (huffmanTableEntry.tagLength + 3 * n5 > 6) {
                    n4 = this.getBits(n5 - (6 - huffmanTableEntry.tagLength - 2 * n5), "z");
                    n2 = n2 << n5 - (6 - huffmanTableEntry.tagLength - 2 * n5) | n4;
                }
            } else {
                n4 = this.getBits(n5 - (6 - huffmanTableEntry.tagLength - n5), "y");
                n3 = n3 << n5 - (6 - huffmanTableEntry.tagLength - n5) | n4;
                n2 = this.getBits(n5, "z");
            }
        } else {
            n4 = this.getBits(n5 - (6 - huffmanTableEntry.tagLength), "x");
            n9 = n9 << n5 - (6 - huffmanTableEntry.tagLength) | n4;
            n3 = this.getBits(n5, "y");
            n2 = this.getBits(n5, "z");
        }
        n9 <<= 32 - n5;
        n3 <<= 32 - n5;
        n2 <<= 32 - n5;
        short s = (short)((n9 >>= 32 - n5) << huffmanTableEntry.rightShift);
        short s2 = (short)((n3 >>= 32 - n5) << huffmanTableEntry.rightShift);
        short s3 = (short)((n2 >>= 32 - n5) << huffmanTableEntry.rightShift);
        if (huffmanTableEntry.absolute != 0) {
            this.curX = s;
            this.curY = s2;
            this.curZ = s3;
        } else {
            this.curX = (short)(this.curX + s);
            this.curY = (short)(this.curY + s2);
            this.curZ = (short)(this.curZ + s3);
        }
        if (n8 != 0) {
            this.meshIndex = this.meshIndex + 1 & 0xF;
            this.meshBuffer[this.meshIndex].x = this.curX;
            this.meshBuffer[this.meshIndex].y = this.curY;
            this.meshBuffer[this.meshIndex].z = this.curZ;
        }
        float f2 = this.curX;
        f2 = (float)((double)f2 / 32768.0);
        float f3 = this.curY;
        f3 = (float)((double)f3 / 32768.0);
        float f4 = this.curZ;
        f4 = (float)((double)f4 / 32768.0);
        this.curPos.set(f2, f3, f4);
        return n8;
    }

    private void processSetNormal(int n2) {
        this.meshState &= 0xFFFFFFFE;
        HuffmanTableEntry huffmanTableEntry = this.gctables[2][this.currentHeader & 0x3F];
        int n3 = huffmanTableEntry.dataLength - huffmanTableEntry.rightShift;
        if (huffmanTableEntry.absolute != 0) {
            int n4 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength];
            if (huffmanTableEntry.tagLength != 0) {
                int n5 = this.getBits(6 - (6 - huffmanTableEntry.tagLength), "sex/oct");
                n4 = n4 << 6 - (6 - huffmanTableEntry.tagLength) | n5;
            }
            this.curU = this.getBits(n3, "u");
            this.curV = this.getBits(n3, "v");
            this.curU <<= huffmanTableEntry.rightShift;
            this.curV <<= huffmanTableEntry.rightShift;
            this.curSex = n4 >> 3 & 7;
            this.curOct = n4 & 7;
        } else {
            int n6;
            int n7 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength];
            if (huffmanTableEntry.tagLength + n3 < 6) {
                n7 >>= 6 - huffmanTableEntry.tagLength - n3;
                n6 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - n3];
                if (huffmanTableEntry.tagLength + 2 * n3 < 6) {
                    n6 >>= 6 - huffmanTableEntry.tagLength - 2 * n3;
                } else if (huffmanTableEntry.tagLength + 2 * n3 > 6) {
                    int n8 = this.getBits(n3 - (6 - huffmanTableEntry.tagLength - n3), "dv");
                    n6 = n6 << n3 - (6 - huffmanTableEntry.tagLength - n3) | n8;
                }
            } else if (huffmanTableEntry.tagLength + n3 > 6) {
                int n9 = this.getBits(n3 - (6 - huffmanTableEntry.tagLength), "du");
                n7 = n7 << n3 - (6 - huffmanTableEntry.tagLength) | n9;
                n6 = this.getBits(n3, "dv");
            } else {
                n6 = this.getBits(n3, "dv");
            }
            n7 <<= 32 - n3;
            n7 >>= 32 - n3;
            n6 <<= 32 - n3;
            n6 >>= 32 - n3;
            this.curU += (n7 <<= huffmanTableEntry.rightShift);
            this.curV += (n6 <<= huffmanTableEntry.rightShift);
            if (this.curU < 0 || this.curV < 0 || this.curU + this.curV > 64) {
                if (this.curU < 0 && this.curV >= 0) {
                    this.curU = -this.curU;
                    switch (this.curSex) {
                        case 0: {
                            this.curSex = 4;
                            break;
                        }
                        case 1: {
                            this.curSex = 5;
                            break;
                        }
                        case 2: {
                            this.curSex = 3;
                            break;
                        }
                        case 3: {
                            this.curSex = 2;
                            break;
                        }
                        case 4: {
                            this.curSex = 0;
                            break;
                        }
                        case 5: {
                            this.curSex = 1;
                        }
                    }
                } else if (this.curU >= 0 && this.curV < 0) {
                    this.curV = -this.curV;
                    switch (this.curSex) {
                        case 1: 
                        case 5: {
                            this.curOct ^= 4;
                            break;
                        }
                        case 0: 
                        case 4: {
                            this.curOct ^= 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.curOct ^= 1;
                        }
                    }
                } else if (this.curU + this.curV > 64) {
                    this.curU = 64 - this.curU;
                    this.curV = 64 - this.curV;
                    switch (this.curSex) {
                        case 0: {
                            this.curSex = 2;
                            break;
                        }
                        case 1: {
                            this.curSex = 3;
                            break;
                        }
                        case 2: {
                            this.curSex = 0;
                            break;
                        }
                        case 3: {
                            this.curSex = 1;
                            break;
                        }
                        case 4: {
                            this.curSex = 5;
                            break;
                        }
                        case 5: {
                            this.curSex = 4;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryDecompressor1"));
                }
            }
        }
        if (n2 != 0) {
            this.meshBuffer[this.meshIndex].sextant = (short)this.curSex;
            this.meshBuffer[this.meshIndex].octant = (short)this.curOct;
            this.meshBuffer[this.meshIndex].u = (short)this.curU;
            this.meshBuffer[this.meshIndex].v = (short)this.curV;
        }
        this.indexNormal(this.curSex, this.curOct, this.curU, this.curV, this.curNorm);
        if (!this.bundlingNorm) {
            this.outputNormal(this.curNorm);
        }
    }

    private void indexNormal(int n2, int n3, int n4, int n5, Vector3f vector3f) {
        float f2;
        float f3;
        float f4;
        if (n2 > 5) {
            switch (n3 & 1) {
                case 0: {
                    switch ((n2 & 1) << 1 | (n3 & 4) >> 2) {
                        case 0: {
                            f4 = 1.0f;
                            f3 = 0.0f;
                            f2 = 0.0f;
                            break;
                        }
                        case 1: {
                            f2 = 1.0f;
                            f3 = 0.0f;
                            f4 = 0.0f;
                            break;
                        }
                        default: {
                            f3 = 1.0f;
                            f2 = 0.0f;
                            f4 = 0.0f;
                        }
                    }
                    n2 = 0;
                    n3 = (n3 & 2) >> 1;
                    n3 = n3 << 2 | n3 << 1 | n3;
                    break;
                }
                default: {
                    n3 = (n2 & 1) << 2 | n3 >> 1;
                    n2 = 0;
                    f2 = f3 = (float)(1.0 / Math.sqrt(3.0));
                    f4 = f3;
                }
            }
            if ((n3 & 1) != 0) {
                f3 = -f3;
            }
            if ((n3 & 2) != 0) {
                f2 = -f2;
            }
            if ((n3 & 4) != 0) {
                f4 = -f4;
            }
        } else {
            float f5;
            f4 = (float)gcNormals[n5][n4][0];
            f2 = (float)gcNormals[n5][n4][1];
            f3 = (float)gcNormals[n5][n4][2];
            if ((n2 & 4) != 0) {
                f5 = f4;
                f4 = f3;
                f3 = f5;
            }
            if ((n2 & 2) != 0) {
                f5 = f2;
                f2 = f3;
                f3 = f5;
            }
            if ((n2 & 1) != 0) {
                f5 = f4;
                f4 = f2;
                f2 = f5;
            }
            if ((n3 & 1) != 0) {
                f3 = -f3;
            }
            if ((n3 & 2) != 0) {
                f2 = -f2;
            }
            if ((n3 & 4) != 0) {
                f4 = -f4;
            }
        }
        vector3f.set(f4, f2, f3);
    }

    private void processSetColor(int n2) {
        int n3;
        int n4;
        this.meshState &= 0xFFFFFFFD;
        HuffmanTableEntry huffmanTableEntry = this.gctables[1][this.currentHeader & 0x3F];
        int n5 = huffmanTableEntry.dataLength - huffmanTableEntry.rightShift;
        int n6 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength];
        int n7 = 0;
        if (huffmanTableEntry.tagLength + n5 == 6) {
            n4 = this.getBits(n5, "g");
            n3 = this.getBits(n5, "b");
            if (this.doingAlpha) {
                n7 = this.getBits(n5, "a");
            }
        } else if (huffmanTableEntry.tagLength + n5 < 6) {
            n6 >>= 6 - huffmanTableEntry.tagLength - n5;
            n4 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - n5];
            if (huffmanTableEntry.tagLength + 2 * n5 == 6) {
                n3 = this.getBits(n5, "b");
                if (this.doingAlpha) {
                    n7 = this.getBits(n5, "a");
                }
            } else if (huffmanTableEntry.tagLength + 2 * n5 < 6) {
                n4 >>= 6 - huffmanTableEntry.tagLength - 2 * n5;
                n3 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - 2 * n5];
                if (huffmanTableEntry.tagLength + 3 * n5 == 6) {
                    if (this.doingAlpha) {
                        n7 = this.getBits(n5, "a");
                    }
                } else if (huffmanTableEntry.tagLength + 3 * n5 < 6) {
                    n3 >>= 6 - huffmanTableEntry.tagLength - 3 * n5;
                    if (this.doingAlpha) {
                        n7 = this.currentHeader & BMASK[6 - huffmanTableEntry.tagLength - 4 * n5];
                        if (huffmanTableEntry.tagLength + 4 * n5 < 6) {
                            n7 >>= 6 - huffmanTableEntry.tagLength - 3 * n5;
                        } else if (huffmanTableEntry.tagLength + 4 * n5 > 6) {
                            int n8 = this.getBits(n5 - (6 - huffmanTableEntry.tagLength - 3 * n5), "a");
                            n7 = n7 << n5 - (6 - huffmanTableEntry.tagLength - 3 * n5) | n8;
                        }
                    }
                } else {
                    int n9 = this.getBits(n5 - (6 - huffmanTableEntry.tagLength - 2 * n5), "b");
                    n3 = n3 << n5 - (6 - huffmanTableEntry.tagLength - 2 * n5) | n9;
                    if (this.doingAlpha) {
                        n7 = this.getBits(n5, "a");
                    }
                }
            } else {
                int n10 = this.getBits(n5 - (6 - huffmanTableEntry.tagLength - n5), "g");
                n4 = n4 << n5 - (6 - huffmanTableEntry.tagLength - n5) | n10;
                n3 = this.getBits(n5, "b");
                if (this.doingAlpha) {
                    n7 = this.getBits(n5, "a");
                }
            }
        } else {
            int n11 = this.getBits(n5 - (6 - huffmanTableEntry.tagLength), "r");
            n6 = n6 << n5 - (6 - huffmanTableEntry.tagLength) | n11;
            n4 = this.getBits(n5, "g");
            n3 = this.getBits(n5, "b");
            if (this.doingAlpha) {
                n7 = this.getBits(n5, "a");
            }
        }
        n6 <<= 32 - n5;
        n4 <<= 32 - n5;
        n3 <<= 32 - n5;
        n7 <<= 32 - n5;
        short s = (short)((n6 >>= 32 - n5) << huffmanTableEntry.rightShift);
        short s2 = (short)((n4 >>= 32 - n5) << huffmanTableEntry.rightShift);
        short s3 = (short)((n3 >>= 32 - n5) << huffmanTableEntry.rightShift);
        short s4 = (short)((n7 >>= 32 - n5) << huffmanTableEntry.rightShift);
        if (huffmanTableEntry.absolute != 0) {
            this.curR = s;
            this.curG = s2;
            this.curB = s3;
            if (this.doingAlpha) {
                this.curA = s4;
            }
        } else {
            this.curR = (short)(this.curR + s);
            this.curG = (short)(this.curG + s2);
            this.curB = (short)(this.curB + s3);
            if (this.doingAlpha) {
                this.curA = (short)(this.curA + s4);
            }
        }
        if (n2 != 0) {
            this.meshBuffer[this.meshIndex].r = this.curR;
            this.meshBuffer[this.meshIndex].g = this.curG;
            this.meshBuffer[this.meshIndex].b = this.curB;
            this.meshBuffer[this.meshIndex].a = this.curA;
        }
        float f2 = this.curR;
        f2 = (float)((double)f2 / 32768.0);
        float f3 = this.curG;
        f3 = (float)((double)f3 / 32768.0);
        float f4 = this.curB;
        f4 = (float)((double)f4 / 32768.0);
        float f5 = this.curA;
        f5 = (float)((double)f5 / 32768.0);
        this.curColor.set(f2, f3, f4, f5);
        if (!this.bundlingColor) {
            this.outputColor(this.curColor);
        }
    }

    private void processMeshBR() {
        int n2 = this.getBits(1, "mbr");
        int n3 = this.currentHeader >>> 1 & 0xF;
        this.repCode = (this.currentHeader & 1) << 1 | n2;
        n3 = this.meshIndex - n3 & 0xF;
        MeshBufferEntry meshBufferEntry = this.meshBuffer[n3];
        this.curX = meshBufferEntry.x;
        this.curY = meshBufferEntry.y;
        this.curZ = meshBufferEntry.z;
        this.curPos.set((float)this.curX / 32768.0f, (float)this.curY / 32768.0f, (float)this.curZ / 32768.0f);
        if (this.bundlingNorm && (this.meshState & 1) != 0) {
            this.curSex = meshBufferEntry.sextant;
            this.curOct = meshBufferEntry.octant;
            this.curU = meshBufferEntry.u;
            this.curV = meshBufferEntry.v;
            int n4 = this.curSex << 15 | this.curOct << 12 | this.curU << 6 | this.curV;
            this.indexNormal(this.curSex, this.curOct, this.curU, this.curV, this.curNorm);
        }
        if (this.bundlingColor && (this.meshState & 2) != 0) {
            this.curR = meshBufferEntry.r;
            this.curG = meshBufferEntry.g;
            this.curB = meshBufferEntry.b;
            this.curColor.x = this.curR;
            this.curColor.x = (float)((double)this.curColor.x / 32768.0);
            this.curColor.y = this.curG;
            this.curColor.y = (float)((double)this.curColor.y / 32768.0);
            this.curColor.z = this.curB;
            this.curColor.z = (float)((double)this.curColor.z / 32768.0);
            if (this.doingAlpha) {
                this.curA = meshBufferEntry.a;
                this.curColor.w = this.curA;
                this.curColor.w = (float)((double)this.curColor.w / 32768.0);
            }
        }
        this.meshState = 0;
    }

    private void processEos() {
    }

    private void processVNoop() {
        int n2 = this.getBits(5, "noop count");
        int n3 = this.getBits(n2, "noop bits");
    }

    private void processPassThrough() {
        int n2 = this.getBits(24, "passthrough");
        n2 = this.getBits(32, "passthrough");
    }

    private void processSkip8() {
        int n2 = this.getBits(8, "skip8");
    }

    private void benchmarkStart(int n2) {
        this.vertexCount = 0;
        System.err.println(" GeometryDecompressor: decompressing " + n2 + " bytes...");
        this.startTime = J3dClock.currentTimeMillis();
    }

    private void benchmarkPrint(int n2) {
        float f2 = (float)(J3dClock.currentTimeMillis() - this.startTime) / 1000.0f;
        System.err.println("  done in " + f2 + " sec." + "\n" + "  decompressed " + this.vertexCount + " vertices at " + (float)this.vertexCount / f2 + " vertices/sec\n");
        System.err.print("  vertex data present: coords");
        int n3 = 12;
        if (this.bundlingNorm) {
            System.err.print(" normals");
            n3 += 12;
        }
        if (this.bundlingColor) {
            System.err.println(" colors");
            n3 += 12;
        }
        if (this.doingAlpha) {
            System.err.println(" alpha");
            n3 += 4;
        }
        System.err.println();
        System.err.println("  bytes of data in generalized strip output: " + this.vertexCount * n3 + "\n" + "  compression ratio: " + (float)n2 / (float)(this.vertexCount * n3) + "\n");
    }

    static {
        for (int i2 = 0; i2 < 65; ++i2) {
            for (int i3 = 0; i3 < 65; ++i3) {
                if (i2 + i3 > 64) continue;
                double d2 = 0.615479709 * ((double)i2 / 64.0);
                double d3 = Math.asin(Math.tan(0.615479709 * ((double)(64 - i3) / 64.0)));
                double d4 = Math.cos(d3) * Math.cos(d2);
                double d5 = Math.sin(d2);
                double d6 = Math.sin(d3) * Math.cos(d2);
                int n2 = (int)(d4 *= 16384.0);
                d4 = n2;
                int n3 = (int)(d5 *= 16384.0);
                d5 = n3;
                int n4 = (int)(d6 *= 16384.0);
                d6 = n4;
                GeometryDecompressor.gcNormals[i2][i3][0] = d4 /= 16384.0;
                GeometryDecompressor.gcNormals[i2][i3][1] = d5 /= 16384.0;
                GeometryDecompressor.gcNormals[i2][i3][2] = d6 /= 16384.0;
            }
        }
    }

    static class HuffmanTableEntry {
        int tagLength;
        int dataLength;
        int rightShift;
        int absolute;

        HuffmanTableEntry() {
        }

        public String toString() {
            return " tag length: " + this.tagLength + " data length: " + this.dataLength + " shift: " + this.rightShift + " abs/rel: " + this.absolute;
        }
    }

    static class MeshBufferEntry {
        short x;
        short y;
        short z;
        short octant;
        short sextant;
        short u;
        short v;
        short r;
        short g;
        short b;
        short a;

        MeshBufferEntry() {
        }
    }
}

